<?php

class Backup_Database extends rs {
    /**
     * Host where database is located
     */
    var $host = '';

    /**
     * Username used to connect to database
     */
    var $username = '';

    /**
     * Password used to connect to database
     */
    var $passwd = '';

    /**
     * Database to backup
     */
    var $dbName = '';

    /**
     * Database charset
     */
    var $charset = '';

    /**
     * Constructor initializes database
     */
    function Backup_Database($host, $username, $passwd, $dbName, $charset = 'utf8'){
        $this->host     = $host;
        $this->username = $username;
        $this->passwd   = $passwd;
        $this->dbName   = $dbName;
        $this->charset  = $charset;
    }

    /**
     * Backup the whole database or just some tables
     * Use '*' for whole database or 'table1 table2 table3...'
     * @param string $tables
     */
    public function backupTables($tables = '*', $outputDir = '.'){
        try
        {
            /**
            * Tables to export
            */
            if($tables == '*'){
                $tables = array();
                //$result = db::query('SHOW TABLES');
                $result = db::query('SELECT `modulo_table`,`modulo_name` FROM `modulos` WHERE NOT `reg_deleted` AND `modulo_active` AND `modulo_table` != "" AND `modulo_link` != "#"');
                while($row = db::fetch_array($result)) {
                    $tables[] = $row;
                }
            } else {
                $tables = is_array($tables) ? $tables : explode(',',$tables);
            }

            $sql = 'CREATE DATABASE IF NOT EXISTS '.$this->dbName.";\n\n";
            $sql .= 'USE '.$this->dbName.";\n";

            /**
            * Iterate tables
            */
            $e = count($tables);
            $h = 1;
            $table_sic ='';

            foreach($tables as $table){

            	if($table['modulo_table']){

	            	$table_sic = $table['modulo_name'];
	                $result    = db::query('SELECT * FROM '.db::ftquote($table['modulo_table']));
	                $numFields = db::num_rows($result);

	                $sql .= 'DROP TABLE IF EXISTS '.$table['modulo_table'].';';
	                $row2 = db::fetch_array(db::query('SHOW CREATE TABLE '.$table['modulo_table']));
	                $sql .= "\n\n".$row2[1].";\n\n";

	                $rst = db::query('SHOW FULL COLUMNS FROM '.$table['modulo_table']);

	                while($r = db::fetch_array($rst)){
	                	$fields[] = $r;
	                }

	                for ($i = 0; $i < $numFields; $i++){

	                	if($numFields > 0) {

		                    while($row = db::fetch_assoc($result)){

		                    	$sql .= 'INSERT INTO '.db::ftquote($table['modulo_table']).' (';
								$g = 0;
		                        foreach($fields as $field){

		                       		$sql .= db::ftquote($field['Field']);

		                        	if ($g < count($fields) - 1){
		                        		$sql .= ',';
		                        	}
		                        	$g++;
		                        }

								$sql .= ')';
								$sql .= "\n";
								$sql .= 'VALUES(';

								$j = 0;
								foreach($fields as $field){

									if (isset($row[$field['Field']])){
										$sql .= db::quote($row[$field['Field']]);
		                            } else {
		                                $sql .= '""';
		                            }

		                            if ($j < count($fields)-1){
		                                $sql .= ',';
		                            }
		                            $j++;
		                        }

		                        $sql.= ");\n";
		                    }
	                	}

	                	unset($fields);
	                }

	                $x = $h * 100 / $e;
	                $h++;

	                flush_buffers("<script>parent.cargador(".round($x).",' [respaldando -> ".$table_sic."]');</script>");
	                $sql .="\n\n";
            	}
            }

            $this->saveFile($sql, $outputDir);
        }

        catch (Exception $e)
        {
            var_dump($e->getMessage());
            return false;
        }
    }

    /**
     * Save SQL to file
     * @param string $sql
     */
    protected function saveFile($sql, $outputDir = '.'){
        if (!$sql){
        	flush_buffers("<script>parent.error('DB NOT FOUND');</script>");
        	exit();
        }

        try
        {

        	$file = $this->dbName.'-'.date("Ymd-His");

        	$handle = fopen($outputDir.'/'.$file.'.sql','w+');
        	fwrite($handle, $sql);
            fclose($handle);

            $zip = new ZipArchive();
            $zip_name = $outputDir.'/'.$file.'.zip';

            if ($zip->open($zip_name, ZIPARCHIVE::CREATE) !== TRUE) {
            	flush_buffers("<script>parent.error('Imposible abrir el fichero');</script>");
            	exit();
            }

            $zip->addFile($outputDir.'/'.$file.'.sql');
            $zip->close();

            try
            {
            	$a = new PharData($outputDir.'/'.$file.'.tar');

            	$a->addFile($outputDir.'/'.$file.'.sql');

            	$a->compress(Phar::GZ);

            	flush_buffers('<script>parent.read_file(\''.$outputDir.'/'.$file.'.tar.gz\');</script>');

            	unlink($outputDir.'/'.$file.'.zip');
            	unlink($outputDir.'/'.$file.'.tar');
            	unlink($outputDir.'/'.$file.'.sql');
            }
            catch (Exception $e)
            {
            	//echo "Exception: " . $e->getMessage();
            	flush_buffers("<script>parent.error('".$e->getMessage()."');</script>");
            	exit();
            }

        }
        catch (Exception $e)
        {
            //var_dump($e->getMessage());
        	flush_buffers("<script>parent.error('".$e->getMessage()."');</script>");
            exit();
            //return false;
        }

        return true;
    }
}

?>