<?php
/**
 * Check Class
 *
 * @author Pelado
 */

class Check{

	/**
	 * Check Number
	 *
	 * @param string $value
	 * @param integer $min
	 * @return boolean
	 */
	public static function number($value, $min = 0){

		if(!preg_match("#^[+-]?[0-9]*\.?[0-9]+$#", $value)){
			return false;
		}else {
			if(strlen($value) < $min){
				return false;
			}else {
				return true;
			}
		}
	}

	/**
	 * Check Length
	 *
	 * @param string $value
	 * @param integer $min
	 * @param integer $max
	 * @return boolean
	 */
	public static function length($value, $min = 0, $max = 0){

		if(strlen(trim($value)) < $min){
			return false;
		}

		if($max != 0 && strlen(trim($value)) > $max){
			return false;
		}

		return true;

	}

	/**
	 * Check Email
	 *
	 * @param string $email
	 * @return boolean
	 */
	public static function email($email){

		if( preg_match("#^[\w.-]+@[\w.-]+\.[a-zA-Z]{2,6}$#", $email)){
			if(checkdnsrr(array_pop(explode("@",$email)),"MX")){
				return true;
			}else {
				return false;
			}
		}else{
			return false;
		}
	}

	/**
	 * Check Custom Date
	 *
	 * @param string $custom_date
	 * @param string $custom_date_format
	 */
	public static function custom_date($custom_date, $custom_date_format = ''){

		// Defaults (dd/mm/yyyy)
		$sep   = "/";
		$day   = 0;
		$month = 1;
		$year  = 2;

		switch($custom_date_format){

			case 'dd/mm/yyyy':
				$sep   = "/";
				$day   = 0;
				$month = 1;
				$year  = 2;
				break;

			case 'Y-m-d';
				$sep   = "-";
				$day   = 2;
				$month = 1;
				$year  = 0;

		}

		$date_arr = explode($sep, $custom_date);

		if(!is_array($date_arr)){
			return false;
		}

		if(count($date_arr) != 3){
			return false;
		}

		if(!is_numeric($date_arr[$month]) || !is_numeric($date_arr[$day]) || !is_numeric($date_arr[$year])){
			return false;
		}

		if(!checkdate($date_arr[$month], $date_arr[$day], $date_arr[$year])){
			return false;
		}

		return true;

	}

}

?>