<?php
/**
 * Crop Class
 *
 * @author Peladito
 * @package mio
 **/

define("ccTOPLEFT",     0);
define("ccTOP",         1);
define("ccTOPRIGHT",    2);
define("ccLEFT",        3);
define("ccCENTRE",      4);
define("ccRIGHT",       5);
define("ccBOTTOMLEFT",  6);
define("ccBOTTOM",      7);
define("ccBOTTOMRIGHT", 8);

class File_Uploader_Crop extends rs {

	private $file;

	private $_path;

	public $_file_name = "file_to_upload.jpg";

	public $marca_aguna = false;

	public $_crop = true;

	public $_overwrite = true;

	private $_mime_type;

	public $_ext_img = array('jpg','gif','png','jpeg');

	protected $_original = "upload_file_name";

	public $_put_logo = true;

	public $_logo = "/img/header/logo_sistema.png";

	public $size = 50000000;

	public $_put_text = false;

	public $_font_text = 10;

	public $_file_ext;

	public $_file_data_form;

	private $_type_file;

	public $_control_size = false;

	public $_file_save;

	public $_minHeight = 90;

	public $_minWidth = 90;

	public $_maxHeight = 1500;

	public $_maxWidth = 2000;

	public $_new_name;

	public $_debug = true;

	public $_logname = "log";

	public $_path_log = "logs/";

	public $errors = array();

	public $_ext = array('jpg','gif','png','pdf','txt','doc','xml','jpeg','xls','csv','it');

	public $_position = ccTOPLEFT;

	public $_multiple_association = false;

	public $filter = "";

	public $_cascade = array();

	public $_upload = false;

	public $tinymce = 0;

	private $not_file = array();

	private $_class = 'alert-danger';

   /**
	* Crop class
	* @author programmer Peladito
	* @param string $path
	* @param string $file_name
	* @param int $crop
	* @param int $overwrite
	* @param string $new_name
	* @todo Si no le pasamos $file, podemos hacer una grilla de archivos del path...en fin hacer algo, pero todo depende que le pasemos
	**/
	public function __construct($path){
		$this->_is_dir($path);
	}

	public function upload(){

		$this->_put_logo = $this->marca_aguna;

		($_FILES[$this->_file_data_form]['name'])? $this->_file_name = $_FILES[$this->_file_data_form]['name']: 'file_to_upload.jpg';

		if($this->_file_name) {

			$this->_upload = $this->_type($this->_file_name);
			$this->_upload = $this->_check_ext($this->_file_ext);
			$this->_file_name = $this->_new_name();
		}

		if($this->_upload){

			if (strpos(strtolower($_SERVER["CONTENT_TYPE"]), 'multipart/') === 0) {
					$this->_upload = $this->_uploader_File();
				} else {
					$this->_upload = $this->_uploader_XMLHttpRequest();
			}

			if (strpos(strtolower($_SERVER["HTTP_X_MIME_TYPE"]), 'image/') === 0) {
				 $this->_mime_type = "image";
			}elseif (strpos(strtolower($this->_type_file), 'image/') === 0){
				 $this->_mime_type = "image";
			}else{
				 $this->_mime_type = "application";
			}

			$this->file = $this->_file_name_save();

			if($this->_load_file()){
				$this->_upload = $this->_save();
			}else{
				$this->_upload = false;
				$this->_unlink();
			}
		}

		$this->debug();
	}

	public function show_errors(){

		if(isset($this->errors)){
			$errors = $this->errors[0];
			$errors = mb_substr($errors,mb_stripos($errors,"**"));
			$this->_unlink();
			return $errors;
		}else{
			return false;
		}
	}

	/**
	 * @param string $data
	 * @return mixed errores o bug en archivo
	 */
	public function debug($data=false){

		if($this->_debug){
			$path = BASE_PATH.$this->_path_log;
				if(count($this->errors) > 0){
					$write = $this->errors;
					rs::eLog("\r\n " . print_r($write,true) . "\r\n", $this->_path_log.$_SESSION['user']['admin_id']."_".$this->_logname);

				}elseif($data){
					$write = $data;
					rs::eLog(" \r\n". $write . " \r\n",	$this->_path_log.$_SESSION['user']['admin_id']."_".$this->_logname);
				}
		}
	}

	public function tamano_archivo($peso , $decimales = 2 ) {
		 $clase = array(" Bytes", " KB", " MB", " GB", " TB");
		 return round($peso/pow(1024,($i = floor(log($peso, 1024)))),$decimales ).$clase[$i];
	}
	/**
	 * @param @static $path
	 * @return false OR array de files in the path
	 */
	public function _list_path(){

		try
		{
			$paths = new DirectoryIterator($this->_path);

			foreach ($paths AS $files){
				if(!$files->isDir()){
					if(!$files->isDot()){
						if($files->isFile()){

							if (version_compare(PHP_VERSION, '5.3.10', '<')) {
								$fileName = $files->getFilename();
								$pos_dot = strrpos($fileName, "."); // find '.'
								$ext = ($pos_dot !== false) ? substr($fileName, $pos_dot+1) : null;
							}else{
								$ext = $files->getExtension();
							}

							if(in_array($ext, $this->_ext)){
								if(preg_match("/$this->filter/i",$files->getFilename())){
									$file[$files->key()]['name'] = $files->getFilename();
									$file[$files->key()]['ext']  = $ext;
									$file[$files->key()]['size'] = $this->tamano_archivo($files->getSize());
									$file[$files->key()]['last'] = $files->getMTime();
								}
						   }
						}
					}
				}
			}

			if($this->filter != "" AND count($file) == 0){
				$this->not_file[1] = 'No hay archivos con tal filtro';
				$this->not_file[2] = 'Ingrese un nueva busqueda o deje el campo vacio y pulse filtar para ver todos los archivos';
				return false;
			}

			if(count($file) == 0){
				$this->not_file[1] = 'Sin archivos para listar';
				$this->not_file[2] = 'Esta carpeta no contiene archivos validos para mostrar';
				$this->_class = "alert-warning";
				return false;
			}

			foreach ($file AS $key => $val){
				$date      = $val['last'];
				$row[$key] = $date;
			}

			arsort($row,SORT_NUMERIC);

			foreach ($file AS $key => $val){
				$row[$key] = $val;
			}
			return $row;

		} catch (Exception $e){
			$this->errors[$e->getMessage()];
		}
	}

	/**
	 * @param int $pag
	 * @param int $max
	 * @return void html de archivos paginados
	 */
	public function _list_files($pag,$max=10){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplatefile('file_uploader.tpl.html');

		if(!$this->_list_path()) {

			$tpl->setCurrentBlock("errors");
				$tpl->setVariable("alert_box",      $this->_class);
				$tpl->setVariable("msg_error_body", $this->not_file[2]);
			$tpl->parse("errors");

		}else{

			$tpl->setCurrentBlock("grid");

			$paths = $this->_list_path();

			if($pag){
				$page = (int) $pag;
			} else {
				$page = 1;
			}

			$count = count($paths);
			$pages = ceil($count / $max);

			$files = array_chunk($paths, $max,true);

			if($page > $pages){
				$page = $pages;
			}

			if(count($files) != 0){
				$files = $files[$page-1];
			}

			foreach ($files AS $archivos => $archivo){

				$rut = str_replace($_SERVER['DOCUMENT_ROOT'],'/',$this->_path.$archivo['name']);
				$rut = str_replace("//","/",$rut);
				$tpl->setCurrentBlock("block");
				 $tpl->setVariable(array('name_abrev'=> substr($archivo['name'],0,7).'...['.$archivo['ext'].']',
				 						 'name_real' => $archivo['name'],
									 	 'size'      => $archivo['size'],
				 					     'path_real' => $rut,
				 						 'tinymce'   => $this->tinymce,
				 					 	 'last'	     => date("d/m/Y H:i:s.", $archivo['last']),
				 ));

				 if(in_array($archivo['ext'], $this->_ext)){
				 	$ext = $archivo['ext'];
				 } else {
				 	$ext = "undefined";
				 }

				 if(in_array($archivo['ext'], $this->_ext_img)){
				 	$target = 'rel="prettyPhoto[grid]"'; //rel="prettyPhoto"
				 } else {
				 	$target = 'target="blank"';
				 }

				 $tpl->setVariable("target", $target);

				 switch ($ext){

				 	case 'jpg': case 'gif': case 'png': case 'jpeg':

				 		$tpl->setCurrentBlock("is_img");
				 			 $tpl->setVariable(
				 			 		array('name' => $archivo['name'],
				 					      'path' => $rut,
				 						  'hash' => md5($rut),
				 			));
				 		$tpl->parse("is_img");

				 	break;

				 	default:
				 		$tpl->setCurrentBlock("not_img");
				 			$tpl->setVariable("not_img", '<img src="img/icons/pick/'.$ext.'.png"/>');
				 		$tpl->parse("not_img");
				 	break;

				 }

				$tpl->parse("block");
			}

			$this->js_function = "paginador";

			//$tpl->setVariable("filter", $this->filter);
			//$tpl->setVariable("totales",$count);
			//$tpl->setVariable("desde",  ($page-1) * $max + 1);
			//$tpl->setVariable("hasta",  ($max * $page > $count)? $count : $max * $page);
			//$tpl->setVariable("pag",    $page);
			//$tpl->setVariable("pags",   $pages);

			$tpl->parse("grid");
			$tpl->setVariable('paginado', $this->_pages($page, $count,$max,5));
		}

		return $tpl->get();
	}

	/**
	 * @param int $pag
	 * @param int $max
	 * @return void html de archivos paginados
	 */
	public function _list_files_editor($pag,$max=10){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplatefile('file_uploader_tinymce.tpl.html');

		if(!$this->_list_path()) {

			$tpl->setCurrentBlock("errors");
				$tpl->setVariable("msg_error_body", $this->not_file[2]);
			$tpl->parse("errors");

		}else{

			$tpl->setCurrentBlock("grid");

			$paths = $this->_list_path();

			if($pag){
				$page = (int) $pag;
			} else {
				$page = 1;
			}

			$count = count($paths);
			$pages = ceil($count / $max);

			$files = array_chunk($paths, $max,true);

			if($page > $pages){
				$page = $pages;
			}

			if(count($files) != 0){
				$files = $files[$page-1];
			}

			foreach ($files AS $archivos => $archivo){
				$rut = str_replace($_SERVER['DOCUMENT_ROOT'],'/',$this->_path.$archivo['name']);
				$rut = str_replace("//","/",$rut);
				$tpl->setCurrentBlock("block");
				$tpl->setVariable(array('name' => $archivo['name'],
						'tipo' => $archivo['ext'],
						'size' => $archivo['size'],
						'path'	=> $rut,
						'hash'	=> md5($rut),
						'last'	=> date("d/m/Y H:i:s.", $archivo['last']),
				));

				if(in_array($archivo['ext'], $this->_ext)){
					$ext = $archivo['ext'];
				} else {
					$ext = "undefined";
				}

				if($this->_multiple_association){
					$multiple_association = 1;
					$es_nuevo = 1;
				}else{
					$multiple_association = 0;
					$es_nuevo = 1;
				}

				if(in_array($archivo['ext'], $this->_ext_img)){
					$target = 'rel="prettyPhoto[grid]"';
				} else {
					$target = 'target="blank"';
				}

				$tpl->parse("block");
			}

			$tpl->setVariable('paginado', $this->_pages($page, $count,$max,5));

			$tpl->parse("grid");
		}

		return $tpl->get();
	}

	/**
	 * @param string $file
	 * @param string $path
	 * @final Upload file via php://input solo si el objeto es enviado por ajax
	 */
	private function _uploader_XMLHttpRequest(){

		if(empty($this->_file_name)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **El archivo a subir no existe.';
			if(count(scandir($this->_path)) == 2){
				rmdir($this->_path);
			}
			return false;
		}

		if($_SERVER['CONTENT_LENGTH'] > $this->size){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **El tamaño del archivo ('.$_SERVER['CONTENT_LENGTH'].') es mayor al permitido. Máximo permitido: '.$this->tamano_archivo($this->size).'';
			return false;
		}

		$file = fopen("php://input", "r");

		if(!file_put_contents($this->_file_name_save(), $file)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **El archivo a guardar no existe o bien fue mal subido.';
			return false;
		}

		chmod($this->_file_name_save(), 777);

		return true;
	}

	/**
	 * @example Uploader enctype="multipart/form-data"
	 * @param string file_data_form
	 * @return bool
	 */
	private function _uploader_File(){

		if(empty($this->_file_name)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **El archivo a subir no existe.';
			if(count(scandir($this->_path)) == 2){
				rmdir($this->_path);
			}
			return false;
		}

		$file = $_FILES[$this->_file_data_form]['name'];
		$tmp  = $_FILES[$this->_file_data_form]['tmp_name'];
		$size = $_FILES[$this->_file_data_form]['size'];
		$type = $_FILES[$this->_file_data_form]['type'];

		if($size > $this->size){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **El tamaño del archivo es mayor al permitido. Tamaño máximo permitido: '.get_size($this->size).'';
			return false;
		}

		if(!move_uploaded_file($tmp, $this->_file_name_save())){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **El archivo no pudo ser movido al servidor.';
			return false;
		}

		chmod($this->_file_name_save(), 777);

		$this->_type_file = $type;

		return true;
	}

	/**
	 * @param $path
	 * @return boolean
	 * @tutorial chek de file in the path
	 */
	private function _load_file(){

		if(!file_exists($this->file)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible leer el archivo, o bien este no existe";
			return false;
		}

		chmod($this->file,0755);
		return true;
	}

	private function _replace_file_exist($file){

		if(!$this->_overwrite){
			if(file_exists($this->_path . $file . '.'.$this->_file_ext)) {
				sleep(1);
				$file = $file.'_'.date("H-i-s");
			}
		}
		return $file;
	}

    private function _createfrom(){

    	switch($this->_file_ext){

    		case 'bmp': $file = imagecreatefromwbmp($this->file);
    		break;

    		case 'gif': $file = imagecreatefromgif($this->file);
    		break;

    		case 'jpg': case 'jpeg': $file = imagecreatefromjpeg($this->file);
    		break;

    		case 'png': $file = imagecreatefrompng($this->file);
    		break;

    		default : $file = false;
    	}

    	if(!$file){
    		$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible generar una imagen nueva";
    		return false;
    	}

    	return $file;
	}

	private function _resampled($w=0,$h=0){

		if(!list($w,$h) = getimagesize($this->file)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible obtener datos del archivo";
			return false;
		}

		if($h < $this->_minHeight){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **La imagen es muy pequeña, minimo: ".$this->_minHeight."px de alto";
			return false;
		}

		if($w < $this->_minWidth){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **La imagen es muy pequeña, minimo: ".$this->_minWidth."px de ancho";
			return false;
		}

		$ext = $this->_file_ext;

		if(!in_array($ext, $this->_ext_img)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible realizar la tarea en un archivo del tipo ".$ext;
			return false;
		}

		if($file = $this->_createfrom());

		$ratio = $w / $h;

		$maxW = $this->_maxWidth;
		$maxH = $this->_maxHeight;

		if($this->_maxWidth / $this->_maxHeight > $ratio){
			$this->_maxWidth = ceil($this->_maxHeight * $ratio);
			$x = ceil(($maxW - $this->_maxWidth) / 2);
			$y = 0;
		}else{
			$this->_maxHeight = ceil($this->_maxWidth / $ratio);
			$y = ceil(($maxH - $this->_maxHeight) / 2);
			$x = 0;
		}

		/**
		 * Recuadro de total de la imagen de w x h pal caso que no entre en 4:3 de proporcion
		 *
		 */

		$this->_file_save = imagecreatetruecolor($maxW, $maxH);
		$fondo = imagecolorallocate($this->_file_save, 255, 255, 255);
		imagefill($this->_file_save, 0, 0, $fondo);

		if($ext == "gif" OR $ext == "png"){
			imagecolortransparent($this->_file_save, imagecolorallocatealpha($this->_file_save, 0, 0, 0, 127));
			imagealphablending($this->_file_save, false);
			imagesavealpha($this->_file_save, true);
		}


		if(!imagecopyresampled($this->_file_save, $file, $x, $y, 0, 0, $this->_maxWidth, $this->_maxHeight, $w, $h)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible crear una nueva imagen";
			return false;
		}

		/**
		 * Logo
		 *
		 */

		if($this->_put_logo){

			$logo = BASE_PATH.$this->_logo;

			$src_logo = imagecreatefrompng($logo);
			imagecolortransparent($src_logo, imagecolorallocatealpha($src_logo, 0, 0, 0, 127));
			imagealphablending($src_logo, false);
			imagesavealpha($src_logo, true);

			$w_logo = imagesx($src_logo);
			$h_logo = imagesy($src_logo);

			$ratio_logo = $w_logo / $h_logo;

			if($w_logo / $h_logo > $ratio_logo){
				$w_logo = ceil($h_logo * $ratio_logo);
			}else{
				$h_logo = ceil($w_logo / $ratio_logo);
			}

			if($w_logo > $maxW){
				$w_logo = ceil($maxW / 2) * $ratio_logo;
				$h_logo = ceil($maxH / 2) * $ratio_logo;
			}

			imagecopyresized($this->_file_save, $src_logo, ceil(($maxW - $w_logo) / 2),	ceil(($maxH - $h_logo) / 2), 0, 0, $w_logo, $h_logo, $w_logo, $h_logo);

		}

		/**
		 * Por si quieren poner texto en la imagen subida
		 *
		 */

		if($this->_put_text){
			putenv('GDFONTPATH=' . INCLUDE_PATH . 'fonts/');
			imagefill($this->_file_save, 0, 0, $fondo);
			$red = imagecolorallocate($this->_file_save, 0xFF, 0x00, 0x00);
			imagefttext($this->_file_save, $this->_font_text, 0, $x, $y, $red, 'elephant.ttf', 'Sociedad Apicola');
		}

		if(!$this->_file_save){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible generar una imagen nueva con otro tamaño";
			return false;
		}

		return true;
	}

	public function _position($w, $h){

		switch($this->_position) {
			case ccTOPLEFT:
				return array(0, 0);
				break;
			case ccTOP:
				return array(ceil(($this->_maxWidth - $w) / 2), 0);
				break;
			case ccTOPRIGHT:
				return array(($this->_maxWidth - $w), 0);
				break;
			case ccLEFT:
				return array(0, ceil(($this->_maxHeight - $h) / 2));
				break;
			case ccCENTRE:
				return array(ceil(($this->_maxWidth - $w) / 2), ceil(($this->_maxHeight - $h) / 2));
				break;
			case ccRIGHT:
				return array(($this->_maxWidth - $w), ceil(($this->_maxHeight - $h) / 2));
				break;
			case ccBOTTOMLEFT:
				return array(0, ($this->_maxHeight - $h));
				break;
			case ccBOTTOM:
				return array(ceil(($this->_maxWidth - $w) / 2), ($this->_maxHeight - $h));
				break;
			case ccBOTTOMRIGHT:
				return array(($this->_maxWidth - $w), ($this->_maxHeight - $h));
				break;
		}

	}

	public function _cascade_resampled(){

		if(is_array($this->_cascade) AND count($this->_cascade) > 0){

			foreach ($this->_cascade AS $keys => $values){

					$this->_file_name = $values[0];
					$this->_maxWidth  = $values[1];
					$this->_maxHeight = $values[2];

					$retorno[$keys] = $this->_save();
			}

			return $retorno;
		}else{

			return false;
		}
	}

	public function _save(){

		$to_save = false;
		$save = $this->_file_name_save();

		if($this->_control_size){
			list($w,$h) = getimagesize($save);
			if($w > $this->_maxWidth){
				$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Ancho de imagen debe ser de: ". $this->_maxWidth.'.px';
				return false;
			}

			if($h > $this->_maxHeight){
				$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Alto de imagen debe ser de: ". $this->_maxHeight.'.px';
				return false;
			}
		}

		if($this->_crop && $this->_mime_type == "image"){

			if($this->_resampled()){

				$img = $this->_file_save;
				$ext = $this->_file_ext;

				switch($ext){
					case 'bmp': if(imagewbmp( $img, $save)) $to_save = true;
					break;

					case 'gif': if(imagegif( $img, $save)) $to_save = true;
					break;

					case 'jpg' : case 'jpeg': if(imagejpeg( $img, $save,75)) $to_save = true;
					break;

					case 'png': if(imagepng( $img, $save,9)) $to_save = true;
					break;

					default : $to_save;
					break;
				}
				imagedestroy($img);
				$this->_file_save = $save;
				chmod($save, 0755);
				clearstatcache();
			}

		}else{

			if($this->_file_save);
		   	$to_save = true;
		}

		if(!$to_save){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__." **Imposible guardar el archivo : ". $this->_file_name;
			return false;
		}

		return true;
	}

	public function _file_upload(){
		return $this->_file_name.'.'.$this->_file_ext;
	}

	private function _file_name_save(){
		$file = $this->_path.$this->_file_name.'.'.$this->_file_ext;
		return $file;
	}

	public function _new_name(){

		if($this->_new_name != ""){
			$file = $this->_new_name;
		}else{
			$file = substr($this->_file_name,0,strlen($this->_file_name) - strlen($this->_file_ext) -1 );
		}

		$file = $this->_replace_file_exist($file);

		return $this->_char_illegal($file);
	}

	public function _type($file){

		$type = strtolower(substr(strrchr($file,"."),1));

		if($type){
			$this->_file_ext = $type;
		}else{
			return false;
		}
	}

	public function _unlink(){
		if(count($this->errors) > 0){
			if(file_exists($this->_file_name_save())){
				unlink($this->_file_name_save());
				clearstatcache();
			}
		}
	}

	public function _elements(){

		if($this->_mime_type == "image"){

			$img = $this->_path.$this->_file_save;

			list($w,$h,$type) = getimagesize($img);

			return array("w"=>$w, "h"=>$h, "type" => $type);

		}else{

			$this->errors[] = "Tipo de archivo no valido para esta petición";
			return false;
		}
	}

	private function _char_illegal($original = "") {
		$illegalchars = array ('à','á','ù','"', '\'', '{', '}', '|', '\\', '^', '~', '[', ']',
		                       '`', '#', '\/', ';', '?', ':', '@', '=', '&', '$', '%', '*',
							   'é','è','Û','ü','ä','ò','ó','ñ','ú','ì','í','ç','ć'
		);
		$original = strtolower($original);
		$temp = str_replace($illegalchars, "", $original);
		$temp = str_replace(" ", "_", $temp);
		$temp = strtolower($temp);
		return $temp;
	}

	private function _check_permisos($path){

		if(!is_readable($path)){
			return false;
		}

		if(!is_writable($path)){
			return false;
		}

		return true;
	}

	private function _create_folder($path){

		if(!mkdir($path,0777,true)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__.' **Imposible crear el directorio.';
			return false;
		}

		return $path;
	}

	private function _is_dir($path){

		if(!is_dir($path)){
			if(!$this->_create_folder($path)){
				return false;
			}
		}

		if(!is_readable($path)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__. " **No tiene permisos para leer el directorio.";
			return false;
		}

		if(!is_writable($path)){
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__. " **No tiene permisos para escribir en el directorio.";
			return false;
		}
		chmod($path,  0755);

		$this->_path = $path;
	}

	private function _check_ext($ext){

		if (in_array($ext,$this->_ext)) {
			return true;
		} else {
			$this->errors[] = "linea:".__LINE__." - Function:".__FUNCTION__. "**La extensión no es valida para el archivo ".$this->_file_name;
			return false;
		}
	}

	public function show($img) {

		$img = $this->_path.$img;
		list($w,$h,$type) = getimagesize($img);
		$ele = array("width" => $w, "height" => $h, "type" => $type);
		$this->file = $img;
		$this->_resampled($ele['width'],$ele['height']);

		switch($ele['type']){

			case IMAGETYPE_JPEG:
				header('Content-Type: image/jpeg');
				imagejpeg($this->_file_save,null,75);
				break;

			case IMAGETYPE_GIF:
				header('Content-Type: image/gif');
				imagegif($this->_file_save);
				break;

			case IMAGETYPE_PNG:
				header('Content-Type: image/png');
				imagepng($this->_file_save,null,9);
				break;

			default:
				header('Content-Type: image/jpeg');
				imagejpeg($this->_file_save,null,75);
			break;
		}

	}

	public function __destruct(){
		if(!$this->_upload){
			$this->_unlink();
		}
	}

}
?>