<?php
/**
 * Menu
 *
 * @author Pealado
 */

class Menu extends rs{

	public $modulo = array();
	public $template;
	/**
	 * Constructor
	 */
	public function __construct() {

		parent::__construct();
	}

	/**
	 *
	 * @param $indice
	 * @return @var $this->modulo
	 */
	public function action($indice = 0){
		return $this->modulo[$indice];
	}

	public static function main_menu_users(){

		$menu_user = new HTML_Template_Sigma(TEMPLATES_PATH,TEMPLATES_CACHE_PATH);
		$menu_user->loadTemplateFile("main_menu.tpl.html");

		if(Security::is_logged()){

			$modulos = new Modulos();

			$list_modulos = $modulos->get_list(0,1,' AND `modulo_activo` ',' `modulo_orden` ');

			while ($row = db::fetch_array($list_modulos)){

				$menu_user->setCurrentBlock('modulos');

				if(!$row['modulo_padre']){

					if($row['modulo_link']){
						$link = "index.php?md=".mb_strtolower($row['modulo_link'])."&listar";
					} else {
						$link = "#";
					}

					$menu_user->setVariable('modulo_icon', $row['modulo_icon']);
					$menu_user->setVariable('modulo_nombre', $row['modulo_nombre']);
					$menu_user->setVariable('modulo_link', $link);
					$menu_user->setVariable('modulo_icon', $row['modulo_icon']);

					$m_class= url_friendly($row['modulo_table']);

					if(class_exists($m_class)){
						$class = new $m_class;
						$menu_user->setVariable('count_items', $class->count());
					}
				}

				$sub_modulos = $modulos->get_list(0,1,' AND `modulo_activo` AND `modulo_padre` = '.db::quote($row['modulo_id']).' ',' `modulo_orden` ');

				if(db::num_rows($sub_modulos) > 0){

					$menu_user->setVariable('treeview', 'class="treeview"');
					$menu_user->touchBlock('tree');

					$menu_user->setCurrentBlock('sub_modulo');

					while ($sub = db::fetch_array($sub_modulos)){

						$menu_user->setCurrentBlock('item_sub_modulo');

						$menu_user->setVariable('sub_modulo_link', mb_strtolower($sub['modulo_link']));
						$menu_user->setVariable('sub_modulo_icon_child', $sub['modulo_icon']);
						$menu_user->setVariable('sub_modulo_nombre_child', $sub['modulo_nombre']);

						$m_class = url_friendly($sub['modulo_link']);

						if(class_exists($m_class)){
							$class_sub = new $m_class;
							$menu_user->setVariable('sub_count_items', $class_sub->count());
						}
						$menu_user->parse('item_sub_modulo');
					}
					$menu_user->parse('sub_modulo');
				}

				$menu_user->parse('modulos');
			}

			if(Security::admin_super()){
				$menu_user->touchBlock('admin_super');
			}

			$menu_user->setVariable("admin_pic", $_SESSION['admin']['admin_pic']);
			$menu_user->setVariable("admin_nombre", $_SESSION['admin']['admin_nombre']);
		}

		return $menu_user->get();
	}

	public static function nav_user(){

		$menu_user = new HTML_Template_Sigma(TEMPLATES_PATH,TEMPLATES_CACHE_PATH);
		$menu_user->loadTemplateFile("nav_user.tpl.html");

		if(Security::is_logged()){

			$menu_user->setVariable("admin_pic", $_SESSION['admin']['admin_pic']);
			$menu_user->setVariable("admin_nombre", $_SESSION['admin']['admin_nombre']);
			$menu_user->setVariable('admin_last_login', date_format(date_create($_SESSION['admin']['admin_last_login']), 'd/m/Y H:i:s' ));
		}

		return $menu_user->get();
	}
}

?>