<?php
/**
 * RS Class
 *
 * @author Peladito
 * @package Sociedad Apicola
 */

/**
 * RS Class
 *
 * @package Sociedad Apicola
 */
class rs{

	/**
	 * Table
	 */
	public $table;
	/**
	 * Primary Key
	 */
	public $primary_key;
	/**
	 * Pivot Tables
	 */
	public $pivot_tables;

	public $pivot_fields;
	/**
	 * Debug
	 *
	 * @var booelan
	 */
	public $debug = false;

	public $modulo;

	public $rst_fields;

	public $modulo_id;

	public $parametro_value;

	public $parametro_name;

	public $row;

	public $extra_class = false;

	public $text_selected = "Seleccione...";

	public $js_function = "paginado_simple";

	public $disabled = false;

	public $function_select = false;
	/**
	 * CSV comandos
	 * ...
	 * @var $last_query
	 */
	public $last_query;

	public $sql_query;
	/**
	 * CSv comandos
	 * ...
	 * @var $names_fields
	 */
	public $names_fields = array();

	public $header;

	public $width = 150;

	public $class_combo = "";
	/**
	 * Nombres de combos, se muestran segun el orden que se carguen
	 *
	 * @var array()
	 */
	public $names_combos = array();

	public $separador = " - ";

	public $field_active = false;
	/**
	 * Consulta guardada en variable
	 *
	 * @var $_sql
	 */
	public $_sql;
	/**
	 * Auto Log
	 * @var boolean
	 */
	public $auto_log = true;
	/**
	 * $skip_reg_deleted
	 */
	public $skip_reg_deleted = false;
	/**
	 * Constructor
	 *
	 * @return rs
	 */
	function __construct($modulo_id = false,$modulo = false) {
		if(DEBUG_DB){
			$this->debug = true;
		}
		if($modulo)    $this->modulo    = $modulo;
		if($modulo_id) $this->modulo_id = $modulo_id;
	}

	public function _fields($key,$value){
		$this->$key = $value;
		$this->rst_fields[$key] = $value;
	}
	/**
	 * Get Pivot SQL
	 *
	 * @return string
	 */
	private function get_pivot(){

		$sql = '';

		if(is_array($this->pivot_tables)){

			$last_table = $this->table;

			foreach($this->pivot_tables as $pivot){

				if(isset($pivot['type'])){
					$pivot_type = $pivot['type'];
				}else {
					$pivot_type = ' INNER JOIN ';
				}

				if(isset($pivot['AS'])){
					$pivot_as = $pivot['AS'];
				}else {
					$pivot_as = $pivot['table'];
				}

				if($last_table != $this->table){
					$sql .= ' ' . $pivot_type . ' ' . db::ftquote($pivot['table']) . ' ';
					$sql .= db::ftquote($pivot_as) . ' ON ' . db::ftquote($pivot['table']) . '.' . db::ftquote($pivot['link_a']) . ' = ' . db::ftquote($last_table) . '.' . db::ftquote($pivot['link_b']);
				}else {
					$sql .= ' ' . $pivot_type . ' ' . db::ftquote($pivot['table']) . ' ';
					$sql .= db::ftquote($pivot_as) . ' ON ' . db::ftquote($this->table) . '.' . db::ftquote($pivot['link_a']) . ' = ' . db::ftquote($pivot_as) . '.' . db::ftquote($pivot['link_b']);
				}
				/**
				 * Declara que la tabla para hacer join es la array y no la de la clase, va en el array de la tabla a ser join
				 * ej: $metodo->pivot_tables = array(1 => array("table" => "banners" , "link_a" => "banner_id", "currency" => "NOT", "link_b" => "banner_id"),
				 * 				  				     2 => array("table" => "mayoristas", "link_a" => "mayorista_id", "link_b" => "mayorista_id"));
				 *
				 * Aca banners hace join con la tabla mayorista y no con la tabla del metodo
				 */
				if(isset($pivot['current']) == "NOT"){
					$last_table = $pivot['table'];
				}
			}
		}

		return $sql;

	}
	/**
	 * Log
	 * @param string $module
	 * @param integer $reg_id
	 * @return boolean
	 */
	public function log($module = '', $action = '', $reg_id = 0){

		if(Security::is_logged()){

			if($module != 'logs'){

				if(isset($_SERVER['REMOTE_ADDR'])){
					$ip = $_SERVER['REMOTE_ADDR'];
				}else {
					$ip = 0;
				}

				$logs = new Logs();
				$logs->_fields('log_user_id', (int) Security::admin_id());
				$logs->_fields('log_ip', $ip);
				$logs->_fields('log_action', strtoupper($action));
				$logs->_fields('log_modulo', strtoupper($module));
				$logs->_fields('log_modulo_id', (int) $reg_id);
				$logs->_fields('log_uri', $_SERVER['REQUEST_URI']);
				$logs->_fields('log_request', print_r($_REQUEST,1));

				$logs->add();
			}

			db::query("DELETE FROM `logs` WHERE `log_date` < SUBDATE( NOW( ) , INTERVAL 90	DAY )");
		}
		return true;
	}
	/**
	 * Add
	 *
	 * @param array $data
	 * @return integer
	 */
	public function add($after_save=true,$modulo_id=false){

		$rst_fields = array_remove_keys($this->rst_fields,array($this->primary_key));

		$rst_fields = array_map('trim', $rst_fields);

		foreach ($rst_fields AS $key => $value) {
			if($key){
				$fields[] = db::ftquote($key) . " = " . db::quote($value);
			}
		}

		if($modulo_id){
			$this->modulo_id = $modulo_id;
		}

		if($this->modulo_id){
			$sql = "UPDATE ";
			$where = " WHERE ";
			if($this->reg_deleted()){
				$where .= $this->reg_deleted().' AND ';
			}
			$where .= db::ftquote($this->primary_key)  . " = " . db::quote($this->modulo_id) .  " LIMIT 1";
		}else{
			$sql = "INSERT INTO ";
		}

		$sql .= db::ftquote($this->table) . " SET ".implode(", ", $fields);

		if($this->debug){
			$this->show_debug($sql . $where);
		}

		$rst = db::query($sql . $where);

		if(!$rst){
			return false;
		}

		if(db::affected_rows() != 1){
			return false;
		}

		$log_action = "UPDATE";

		if(!$this->modulo_id){
			$this->modulo_id = db::insert_id();
			$log_action = "INSERT";
		}

		if($after_save) $this->get();

		if($this->auto_log){
			$this->sql_query = $sql;
			$this->log($this->table, $log_action, $this->modulo_id);
		}

		return true;
	}
	/**
	 * Show SQL
	 *
	 * @params string $sql
	 */
	public function show_debug($sql){

		if(DEBUG_LOCAL){
			echo '<div class="alert alert-info" style="z-index:99999">' . $sql . '</div>';
		}else{
			mail("julio@3tipos.com", "SQL DEBUG", $sql, 'From: Debug Sql <julio@3tipos.com>','-f julio@3tipos.com');
		}

	}
	/**
	 * Update
	 *
	 * @param array $data
	 * @param integer $id
	 * @return boolean
	 */
	public function update($data, $id){

		$sql = "UPDATE " . db::ftquote($this->table) . " SET ";
		$update = array();

		$data = array_map('trim', $data);

		foreach($data as $key => $value){
			$update[] = db::ftquote($key) . " = " . db::quote($value);
		}

		$sql .= implode(", ", $update);
		$sql .= " WHERE " . db::ftquote($this->primary_key)  . " = " . db::quote($id) .  " LIMIT 1";

		if($this->debug){ $this->show_debug($sql); }

		$rst = db::query($sql);

		if($this->auto_log){
			$this->sql_query = $sql;
			$this->log($this->table, 'UPDATE', $id);
		}

		return $rst;

	}
	/**
	 * Activate - Si se desea personalizar ingresar como array los id
	 *
	 * @param $data
	 * @param $id = array
	 */
	public function update_multi($data, $id){

		$sql = "UPDATE " . db::ftquote($this->table) . " SET ";
		$update = array();

		$data = array_map('trim', $data);

		foreach($data as $key => $value){
			$update[] = db::ftquote($key) . " = " . db::quote($value);
		}

		$sql .= implode(", ", $update);

		if(is_array($id)){
			$ids = implode(", ", $id);
			$sql .= " WHERE " . db::ftquote($this->primary_key)  . " IN( " . $ids .  " )";
		}else{
			$sql .= " WHERE " . db::ftquote($this->primary_key)  . " =  " . db::quote($id) .  " ";
		}

		if($this->debug){ $this->show_debug($sql); }

		$rst = db::query($sql);

		if($this->auto_log){
			$this->sql_query = $sql;
			$this->log($this->table, 'UPDATE', $id);
		}

		return $rst;

	}
	/**
	 * Delete
	 *
	 * @param integer $id
	 * @param boolean $hard
	 * @return boolean
	 */
	public function delete($id, $hard = false){

		if($hard){
			$sql = "DELETE FROM " . db::ftquote($this->table) . " WHERE " . db::ftquote($this->primary_key) . " = " . db::quote($id) . " LIMIT 1";
		}else {
			$sql = "UPDATE " . db::ftquote($this->table) . " SET `reg_deleted` = 1 WHERE " . db::ftquote($this->primary_key) . " = " . db::quote($id) . " LIMIT 1";
		}

		if($this->debug){ $this->show_debug($sql); }

		$rst = db::query($sql);

		if($this->auto_log){
			$this->sql_query = $sql;
			$this->log($this->table, 'DELETE', $id);
		}

		return $rst;

	}

	public function delete_in($id, $hard = false ,$in = false){

		$clausula = ($in)? " IN(". $id .")" : " = ". $id;

		if($hard){
			$sql = "DELETE FROM " . db::ftquote($this->table) . " WHERE " . db::ftquote($this->primary_key) . $clausula;
		}else {
			$sql = "UPDATE " . db::ftquote($this->table) . " SET `reg_deleted` = 1 WHERE " . db::ftquote($this->primary_key) . $clausula;
		}

		if($this->debug){ $this->show_debug($sql); }
		$rst = db::query($sql);

		if($this->auto_log){
			$this->sql_query = $sql;
			$this->log($this->table, 'DELETE', $id);
		}
		return $rst;

	}
	/**
	 * Get
	 *
	 * @param integer $id
	 * @return array
	 */
	public function get($id=false){

		if($id) $this->modulo_id = $id;

		if(!$this->modulo_id) return false;

		$sql = "SELECT " . db::ftquote($this->table) . ".* ";

		if(is_array($this->pivot_tables)){
			foreach($this->pivot_tables as $pivot){
				$sql .= ", " . db::ftquote($pivot['table']) . ".*";
			}
		}

		$sql .= ' FROM ' . db::ftquote($this->table) . ' ';
		$sql .= $this->get_pivot();

		if($this->reg_deleted()){
			$reg_deleted = $this->reg_deleted().' AND ';
		}

		$sql .= " WHERE ".$reg_deleted." " . db::ftquote($this->table) . '.' . db::ftquote($this->primary_key) . " = " . db::quote($this->modulo_id) . " LIMIT 1";

		if($this->debug){
			$this->show_debug($sql);
		}

		$rst = db::query($sql);

		if(!$rst){
			return false;
		}

		if(db::num_rows($rst) != 1){
			return false;
		}

		$data = db::fetch_assoc($rst);

		unset($data['reg_deleted']);

		//$this->rst_fields = $data;

		//print_r($data);
		foreach ($data as $key => $value) {
			if($key) $this->$key = $value;
		}

		return $data;
	}
	/**
	 * Get List
	 *
	 * @param integer $max
	 * @param integer $pag
	 * @param string $where
	 * @param string $order
	 * @return mysql_resource
	 */
	public function get_list($max = 0, $pag = 1, $where = false, $order = false, $grupo = false, $having = false){
		$max = (int) $max;
		$pag = ((int) $pag) - 1;

		if(is_array($this->pivot_fields)){

			$sql = "SELECT ";
			$inner = "";

			foreach($this->pivot_fields AS $field => $as){

					if(strlen($inner)){
						$inner .= ", ";
					}

					if(!is_numeric($field)){
						$inner .= db::ftquote($this->table) . "." . db::ftquote($field).' AS '.db::ftquote($as).'';
					}elseif($as == '*'){
						$inner .= db::ftquote($this->table) . "." . $as;
					}else{
						$inner .= db::ftquote($this->table) . "." . db::ftquote($as);
					}
				}

				$sql .= $inner;
		}else{
			$sql = "SELECT " . db::ftquote($this->table) . ".* ";
		}

		if(is_array($this->pivot_tables)){

			foreach($this->pivot_tables as $pivot){

				if(isset($pivot['AS'])){
					$pivot_as = $pivot['AS'];
				}else {
					$pivot_as = $pivot['table'];
				}

				/**
				 * Traemos solo algunos campos o traemos todos
				 */
                if(is_array($pivot['fields'])){

                	foreach($pivot['fields'] AS $fields => $rn){

                		if(!is_numeric($fields)){
                			$sql .= ", " . db::ftquote($pivot_as) . "." . db::ftquote($fields).' AS '.db::ftquote($rn).'';
                		}else{
                			$sql .= ", " . db::ftquote($pivot_as) . "." . db::ftquote($rn);
                		}
                	}

                }else{

					$sql .= ", " . db::ftquote($pivot_as) . ".*";
                }
			}
		}

		$sql .= ' FROM ' . db::ftquote($this->table) . ' ';
		$sql .= $this->get_pivot();

		if($this->reg_deleted()){
			$sql .= " WHERE " . $this->reg_deleted() . (($where)? $where : '');
		}elseif($where){
			$sql .= " WHERE " .$where;
		}

		if($grupo){
			$agrupado = is_string($grupo) ? $grupo : $this->primary_key;
			$sql .= " GROUP BY ".db::ftquote($this->table).".".db::ftquote(trim($agrupado))." ";
		}

		if($having){
		 $sql .= "	HAVING ". $having. " ";
		}

		if($order != ''){
			$sql .= " ORDER BY " . $order;
		}

		$this->last_query = $sql;

		if($max != 0){
			$from = $max * $pag;

			if($from < 0){
				return false;
			}

			$sql .= " LIMIT " . $from . ", " . $max;
		}
		//echo $sql;
		if($this->debug){ $this->show_debug($sql); }

		$rst = db::query($sql);

		if(!$rst){
			return false;
		}

		return $rst;

	}
	/**
	 * Exist
	 *
	 * @param integer $id
	 * @return boolean
	 */
	public function reg_deleted($table=false){

		if($this->skip_reg_deleted) return false;

		$this->table = ($table)? $table : $this->table;

		$sql = "SHOW FIELDS FROM ".db::ftquote($this->table)." WHERE Field = ".db::quote("reg_deleted")." ";
		$rst = db::query($sql);

		if(db::num_rows($rst) == 1){

			$row = db::fetch_array($rst);
			return " NOT  ".db::ftquote($this->table).".".db::ftquote($row['Field'])." ";
		}
	}

	public function exist($id){
		$count = $this->count(" AND ".db::ftquote($this->primary_key) . ' = ' . db::quote($id));

		if($count == 1){
			return true;
		}else {
			return false;
		}

	}
	/**
	 * Count cuenta
	 *
	 * @param string $where
	 * @return integer
	 */
	public function count($where = false, $grupo = false){

		$sql = "SELECT COUNT(*) AS `count` FROM " . db::ftquote($this->table) . ' ';
		$sql .= $this->get_pivot();

		if($this->reg_deleted()){
			$sql .= " WHERE " . $this->reg_deleted() .  (($where)? $where.' ' : '');
		}elseif($where){
			$sql .= " WHERE " . $where;
		}

		if($grupo){
			is_string($grupo) ? $agrupado = $grupo : $agrupado = $this->primary_key;
			$sql .= " GROUP BY  ".db::ftquote($this->table).".".db::ftquote($agrupado)." ";
		}

		if($this->debug){ $this->show_debug($sql); }

		$rst = db::query($sql);

		if(!$rst){
			return false;
		}

		$count = db::fetch_assoc($rst);

		return $count['count'];

	}

	public function count_reg(){
		$count = db::num_rows(db::query($this->last_query));
		return $count;
	}

    public function mysql_type(){
    	//mysql_field_type
    	$sql = "SELECT * FROM $this->table";
    	$rst = db::query($sql);
    	if($rst){
    		for($i = 0; $i < mysql_num_rows($rst); $i++){
    			$meta = mysql_fetch_field($rst, $i);
    			$name = $meta->multiple_key;
    		}
    		return $name;
    	}
    }

	public static function eLog($msg,$file_name){
	      file_put_contents(BASE_PATH.'/'.$file_name.".log","\r\n <!------------------------".date("Y-m-d H:i:s (T)")."--------------------------> \r\n $msg \r\n <!------------------------------------------------------------------> \r\n",FILE_APPEND);
	}

	public static function data_type_hash(){
		$mysql_data_type_hash = array(
				1=>'tinyint',
				2=>'smallint',
				3=>'int',
				4=>'float',
				5=>'double',
				7=>'timestamp',
				8=>'bigint',
				9=>'mediumint',
				10=>'date',
				11=>'time',
				12=>'datetime',
				13=>'year',
				16=>'bit',
				//252 is currently mapped to all text and blob types (MySQL 5.0.51a)
				253=>'varchar',
				254=>'char',
				246=>'decimal'
		);
	}
	/**
	 * Combo auto generado
	 *
	 * @param $post - valor del request
	 * @param $variable_post - nombre del request
	 * @param $where - clausula opcional
	 * @param $order - order opcional, admite @array()
	 * @param $function - funcion en el evento onchange
	 * @param $disabled - deshablilitar combo
	 * @return html generado
	 */
	public function get_combos($post, $variable_post, $where = false, $order = false, $group = false, $options = false){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile('combos_select.tpl.html');

		$new_order;

		if($order){
			if(is_array($order)){
				foreach ($order As $order_as){
					if(strlen($new_order)){
						$new_order.= ",";
					}
					$new_order.= db::ftquote(trim($order_as));
				}
			}else{
			   $new_order = db::ftquote(trim($order));
			}
		}else{
			$new_order = db::ftquote($this->primary_key);
		}

		$add_where;

		if($this->field_active){
			$add_where.= " AND ".db::ftquote($this->field_active)." ";
		}

		if($where){
			if($this->reg_deleted()){
				$add_where.= ' AND '.$where;
			} else {
				$add_where.= $where;
			}
		}

		$rst = $this->get_list(0,1,$add_where,$new_order,$group);

		asort($this->names_combos);

		$tpl->setCurrentBlock("combo_default");

					$i=0;

					$total_fields = count($this->names_combos['combos_names']);

					if($total_fields == 0){
						$this->names_combos['combos_names'] = $this->primary_key;
						$total_fields = 1;
					}

					while($row = db::fetch_array($rst)){

						    $tpl->setCurrentBlock("row");
							$tpl->setVariable('key', $row[$this->primary_key]);

							$names = "";
							$field = 0;

							foreach ($this->names_combos['combos_names'] AS $text => $name){

								if(strlen($names)){
									if(!is_numeric($text)){
										$names.= $text;
									}else{
										$names.= $this->separador;
									}
								}

								$r = mysqli_fetch_field_direct($rst,$field);

								if($r->type == 10){
									$names.= date_format(date_create($row[$name]),'d/m/Y');
								}else{
									$names.= $row[$name];
								}
								$field++;

							}

							$tpl->setVariable('value', $names);

							if($row[$this->primary_key] == $post){
								$tpl->setVariable("selected","selected");
						    }

							$tpl->parse('row');
							$i++;
					}
					//mysqli_free_result($rst);

					if($options) return $tpl->get("row");

					if($this->text_selected){
						$tpl->setVariable('placeholder', $this->names_combos['first_field']);
					}

					$tpl->setVariable('variable_post', $variable_post);

					if($this->function_select){
						$tpl->setVariable("function", "onchange = ".$this->function_select."");
					}

				    if($this->disabled){
				    	$tpl->setVariable("disabled", 'disabled="disabled"');
				    }

		$tpl->parse("combo_default");

		$module = $tpl->get();

		return  $module;

	}

	public function get_combos_multi($post, $variable_post, $where = false, $order = false, $function = false, $group = false, $Selection = 'Item seleccionado', $Selectable = 'Item seleccionable'){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile('combos_select.tpl.html');

		$new_order;

		if($order){

			if(is_array($order)){

				foreach ($order As $order_as){

					if(strlen($new_order)){
						$new_order.= ",";
					}

					$new_order.= db::ftquote(trim($order_as));
				}

			}else{
				$new_order = db::ftquote(trim($order));
			}

		}else{
			$new_order = db::ftquote($this->primary_key);
		}

		$add_where;

		if($this->field_active){
			$add_where.= " AND ".db::ftquote($this->field_active)." ";
		}

		if($where){
			$add_where.= ' AND '.$where;
		}
		//$this->debug=true;
		$rst = $this->get_list(0,1,$add_where,$new_order,$group);

		asort($this->names_combos);

		$tpl->setCurrentBlock("combo_multi_select");

		$i=0;

		$total_fields = count($this->names_combos['combos_names']);

		if($total_fields == 0){
			$this->names_combos['combos_names'] = $this->primary_key;
			$total_fields = 1;
		}

		while($row = db::fetch_array($rst)){

			$tpl->setCurrentBlock("row_multi_select");
			$tpl->setVariable('key', $row[$this->primary_key]);

			$names = "";
			$field = 0;

			foreach ($this->names_combos['combos_names'] AS $text => $name){

				if(strlen($names)){
					if(!is_numeric($text)){
						$names.= $text;
					}else{
						$names.= $this->separador;
					}
				}

				$r = mysqli_fetch_field_direct($rst,$field);

				if($r->type == 10){
					$names.= date_format(date_create($row[$name]),'d/m/Y');
				}else{
					$names.= $row[$name];
				}
				$field++;

			}

			$tpl->setVariable('value', $names);

			if(in_array($row[$this->primary_key],$post)){
				$tpl->setVariable("selected","selected");
			}

			$tpl->parse('row_multi_select');
			$i++;
		}
		//mysqli_free_result($rst);

		if($this->text_selected){
			$tpl->setVariable('placeholder', $this->names_combos['first_field']);
		}

		$tpl->setVariable('variable_post', $variable_post);

		if($function){
			$tpl->setVariable("function", "onchange = ".$function."");
		}

		if($this->disabled){
			$tpl->setVariable("disabled", 'disabled="disabled"');
		}

		$tpl->setVariable("Selectable", $Selectable);
		$tpl->setVariable("Selection", $Selection);

		$tpl->parse("combo_multi_select");

		$module = $tpl->get();

		return  $module;
	}

	public function combos_dropdown($dropdown_id='', $url='', $combos_dropdown_name='Agregar Solicitud', $where = false, $order = false, $function = false, $group = false){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile('combos_dropdown.tpl.html');

		$new_order;

		if($order){

			if(is_array($order)){

				foreach ($order As $order_as){
					if(strlen($new_order)){
						$new_order.= ",";
					}
					$new_order.= db::ftquote(trim($order_as));
				}

			}else{
				$new_order = db::ftquote(trim($order));
			}

		}else{
			$new_order = db::ftquote($this->primary_key);
		}

		$add_where = '';

		if($this->field_active){
			$add_where.= " AND ".db::ftquote($this->field_active)." ";
		}

		if($where){
			$add_where.= ' AND '.$where;
		}

		$rst = $this->get_list(0,1,$add_where,$new_order,$group);
		asort($this->names_combos);

		$tpl->setCurrentBlock("combos_dropdown");

		$total_fields = count($this->names_combos['combos_names']);

		if($total_fields == 0){
			$this->names_combos['combos_names'] = $this->primary_key;
			$total_fields = 1;
		}

		while($row = db::fetch_array($rst)){
			$tpl->setCurrentBlock("row");
				$tpl->setVariable('url', $url.$row[$this->primary_key]);
				$names = "";
				foreach ($this->names_combos['combos_names'] AS $text => $name){
					if(strlen($names)){
						if(!is_numeric($text)){
							$names.= $text;
						}else{
							$names.= $this->separador;
						}
					}
					$names.= $row[$name];
				}
				$tpl->setVariable('name', $names);
			$tpl->parse('row');
		}

		$tpl->setVariable('dropdown_id', $dropdown_id);
		$tpl->setVariable('combos_dropdown_name', $combos_dropdown_name);

		$tpl->parse("combos_dropdown");

		$module = $tpl->get();

		return  $module;
	}

	public function get_combos_option_group($post, $variable_post, $where = false, $order = false, $parent_field = false, $group = false, $only_options = false){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplateFile('combos_select_option_group.tpl.html');

		$new_order;

		if($order){

			if(is_array($order)){

				foreach ($order As $order_as){

					if(strlen($new_order)){
						$new_order.= ",";
					}

					$new_order.= db::ftquote(trim($order_as));
				}

			}else{
				$new_order = db::ftquote(trim($order));
			}

		}else{
			$new_order = db::ftquote($this->primary_key);
		}

		$add_where;

		if($this->field_active){
			$add_where.= " AND ".db::ftquote($this->field_active)." ";
		}

		if($where){
			$add_where.= ' AND '.$where;
		}

		//$this->debug=true;
		$rst = $this->get_list(0,1,$add_where,$new_order,$group);

		asort($this->names_combos);

		$tpl->setCurrentBlock("combo_default");

		$i=0;

		$total_fields = count($this->names_combos['combos_names']);

		if($total_fields == 0){
			$this->names_combos['combos_names'] = $this->primary_key;
			$total_fields = 1;
		}

		while($row = db::fetch_array($rst)){

			if($row[$parent_field] == 0){
				$field_name = array_values($this->names_combos['combos_names']);
				$tpl->setCurrentBlock("optgroup");
					$tpl->setVariable('optgroup', $row[$field_name[0]]);
			}
				$tpl->setCurrentBlock("row");
				$tpl->setVariable('key', $row[$this->primary_key]);
				$names = "";
				$field = 0;
				foreach ($this->names_combos['combos_names'] AS $text => $name){

					if(strlen($names)){
						if(!is_numeric($text)){
							$names.= $text;
						}else{
							$names.= $this->separador;
						}
					}

					$r = mysqli_fetch_field_direct($rst,$field);

					if($r->type == 10){
						$names.= date_format(date_create($row[$name]),'d/m/Y');
					}else{
						$names.= $row[$name];
					}
					$field++;

				}

				$tpl->setVariable('value', $names);

				if($row[$this->primary_key] == $post){
					$tpl->setVariable("selected","selected");
				}

				$tpl->parse('row');

			if($row[$parent_field] == 0){
				$tpl->parse('optgroup');
			}
			$i++;
		}
		//mysqli_free_result($rst);

		if($only_options) return $tpl->get("row");

		$tpl->setVariable('variable_post', $variable_post);

		if($this->text_selected){
			$tpl->setVariable('placeholder', $this->names_combos['first_field']);
		}

		if($this->function_select){
			$tpl->setVariable("function","onchange = ".$this->function_select."");
		}

		if($this->disabled){
			$tpl->setVariable("disabled", 'disabled="disabled"');
		}

		$tpl->parse("combo_default");

		$module = $tpl->get();

		return  $module;
	}
	/**
	 * Busqueda para enganchar en las grillas...para evitar en ciertos caso hacer inner joins, pinto no se, en algunos casos
	 * me vino bien!!!... busqueda de diferentes tipos, dados ciertos parametros
	 *
	 * @param $kname si se le pasa, busca en ese campos sino en el id
	 * @param $like si es true hacemos like
	 */
	public function get_ids($kname="",$like=false){

		if($this->parametro_name){
			$name = $this->parametro_name;
		}else{
			$name = $this->primary_key;
		}

		if(is_array($this->parametro_value)){
			$rst = $this->get_list(0,1," AND ".db::ftquote($name)." IN( ".implode(",", $this->parametro_value)." )","");
		}else{
			if($like){
				if(is_array($name)){
					$result = "";
					foreach ($name AS $sql){
						if(strlen($result)){
							$result .= " OR ";
						}
						$result .= " ".db::ftquote($sql)." LIKE ". db::quote('%' . $this->parametro_value . '%')." ";
					}
				}else{
					$result = " ".db::ftquote($name)." LIKE ". db::quote('%'. $this->parametro_value . '%')." ";
				}
				$rst = $this->get_list(0,1," AND $result ","");
			}else{
				$rst = $this->get_list(0,1," AND ".db::ftquote($name)." =  ".db::quote($this->parametro_value)." ","");
			}
		}

		if($rst){

			if($kname == ""){
				$kname = $this->primary_key;
			}

			while ($lista = db::fetch_array($rst)){
				$id[] = $lista[$kname];
			}

			return $id;
		}else{
			return false;
		}
	}

	public function _all_data_user(){
		if(isset($_SESSION['user'])){
			$users = new Admins($_SESSION['user']['admin_id']);
			if($row = $users->get()){
				return $row;
			}
		}
		return false;
	}

	public function next_auto_increment(){

		$sql = "SELECT `AUTO_INCREMENT` AS `next_id` FROM `information_schema`.`tables` WHERE TABLE_SCHEMA = ".db::quote(DB_NAME)." AND TABLE_NAME = ".db::quote($this->table)." ";

		if($rst = db::query($sql)){
			$str = db::fetch_array($rst);
			return $str['next_id'];
		}
	}

	public function user_info(){
		if(isset($_SESSION['admin'])){
			$users = new Admins($_SESSION['admin']['admin_id']);
			if($row = $users->get()){
				return $row;
			}
		}
		return false;
	}
	/**
	 *
	 * Paginar algo mas o menos
	 *
	 * @param $tpl  - html a para parsear
	 * @param $pagina  - pagina actual
	 * @param $registros  - cantidad de registros
	 * @param $cant_reg_x_pages - cantidad de registros por pagina
	 * @param $cant_links - cantidad de links a mostrar
	 *
	 * @return Html paginado
	 *
	 */
	public function _pages($page,$registros,$cant_reg_x_pages = 10,$cant_links = 5,$tpls = "paginador_gral.tpl.html"){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplatefile($tpls);

		$page = ((int)$page < 0)? 0 : $page;
		if ($registros < 1) {
			return false;
		}

		$first  = $last = 0;
		$pages	= ceil($registros / $cant_reg_x_pages);

		if ($pages < 2) {
			return false;
		}

		$tpl->setVariable("pags",$pages);
		$tpl->setVariable("pag",$page);

		if ($pages <= $cant_links) {
			$first		= 1;
			$last		= $pages;
		} else {
			$middle 	= floor($cant_links / 2);
			$first      = ($page+1) - $middle;
			$last        = $first + $cant_links - 1;

			if ($last > $pages) {
				$last    = $pages;
				$first  = $last - ($cant_links -1);
			}

			if ($first < 1) {
				$first	= 1;
				$last	= $cant_links;
			}
		}

		$x       = floor($cant_links / 2);
		$x2      = 1 - ($cant_links % 2);
		$b_first = $first - $cant_links + $x  - 1;
		$b_last  = $last + $cant_links - $x  + $x2;

		if($b_first >= $x){
			$tpl->setCurrentBlock("block_prev");
				$tpl->setVariable("block_prev", $b_first);
			$tpl->parse("block_prev");
		}

		if($last <= ($pages - $cant_links - 1)){
			$tpl->setCurrentBlock("block_next");
				$tpl->setVariable("block_next", $b_last-1);
			$tpl->parse("block_next");
		}

		if($page > 1) {
			$tpl->setCurrentBlock('prev_pag');
				$tpl->setVariable('prev_pag',$page-1);
			$tpl->parse('prev_pag');
		}

		if ($page < $pages) {
			$tpl->setCurrentBlock('next_pag');
				$tpl->setVariable('next_pag', $page+1);
			$tpl->parse('next_pag');
		}

		for ( $p = $first; $p <= $last; $p++) {

			$tpl->setCurrentBlock("rows_pag");

				if($p == $page){
					$tpl->setCurrentBlock("rows_span");
						$tpl->setVariable("row_pag_span",$p);
					$tpl->parse("rows_span");

				}else{

					$tpl->setCurrentBlock("rows_a");
						$tpl->setVariable("row_pag_x",$p);
					$tpl->parse("rows_a");
				}

			$tpl->parse("rows_pag");

		}

		$tpl->setVariable("paginado",$this->js_function);

		return $tpl->get();
	}

	public function _pages_site($page,$registros,$cant_reg_x_pages = 10, $path = '/', $cant_links = 5,$tpls = "paginador_custom.tpl.html",$current = "",$selected = "active"){

		$tpl = new HTML_Template_Sigma(TEMPLATES_PATH, TEMPLATES_CACHE_PATH);
		$tpl->loadTemplatefile($tpls);

		$page = ((int)$page < 0)? 0 : $page;
		if ($registros < 1) {
			return false;
		}

		$first  = $last = 0;
		$pages	= ceil($registros / $cant_reg_x_pages);

		if ($pages < 2) {
			return false;
		}

		if ($pages <= $cant_links) {
			$first		= 1;
			$last		= $pages;
		} else {
			$middle 	= floor($cant_links / 2);
			$first      = ($page+1) - $middle;
			$last        = $first + $cant_links - 1;

			if ($last > $pages) {
				$last    = $pages;
				$first  = $last - ($cant_links -1);
			}

			if ($first < 1) {
				$first	= 1;
				$last	= $cant_links;
			}
		}

		$x       = floor($cant_links / 2);
		$x2      = 1 - ($cant_links % 2);
		$b_first = $first - $cant_links + $x  - 1;
		$b_last  = $last + $cant_links - $x  + $x2;

		if($b_first >= $x){
			$tpl->setCurrentBlock("block_prev");
			$tpl->setVariable("block_prev", $b_first);
			$tpl->setVariable("block_path_prev",$path);
			$tpl->parse("block_prev");
		}

		if($last <= ($pages - $cant_links - 1)){
			$tpl->setCurrentBlock("block_next");
			$tpl->setVariable("block_next", $b_last-1);
			$tpl->setVariable("block_path_next",$path);
			$tpl->parse("block_next");
		}

		if($page > 1) {
			$tpl->setCurrentBlock('prev_pag');
			$tpl->setVariable('prev_pag',$page-1);
			$tpl->setVariable("path_prev",$path);
			$tpl->parse('prev_pag');
		}

		if ($page < $pages) {
			$tpl->setCurrentBlock('next_pag');
			$tpl->setVariable('next_pag', $page+1);
			$tpl->setVariable("path_next",$path);
			$tpl->parse('next_pag');
		}

		for ( $p = $first; $p <= $last; $p++) {

			$tpl->setCurrentBlock("rows_pag");

				if($p == $page){
					$tpl->setCurrentBlock("rows_span");
						$tpl->setVariable("row_pag_span",$p);
					$tpl->parse("rows_span");

				}else{

					$tpl->setCurrentBlock("rows_a");
						$tpl->setVariable("row_pag_x",$p);
						$tpl->setVariable("path_pag_x",$path);
					$tpl->parse("rows_a");
				}

			$tpl->parse("rows_pag");

		}

		$tpl->setVariable("paginado",$this->js_function);

		return $tpl->get();
	}
}

?>