<?php
/**
 * Security Class
 *
 * @author Pelado
 * @package Pakete loco
 */

class Security {

	public $error;


	public function Login_As($username,$hash){

		$users = new Admins();
		//$users->debug=true;
		$users_list = $users->get_list(1, 1, ' AND `admin_nombre` AND '.db::ftquote('admin_nombre').' = ' . db::quote($username).' AND `admin_activo` ');

		if(!$users_list){
			$this->error = 'Error Interno';
			return false;
		}

		if(db::num_rows($users_list) != 1){
			$this->error = 'Usuario o contraseña inválidos';
			return false;
		}

		$user = db::fetch_assoc($users_list);

		if(!password_verify($user['admin_nombre'],$hash)){
			$this->error = 'Error Interno';
			return false;
		}

		if($user['admin_activo'] == 0 || $user['reg_deleted'] == 1){
			$this->error = 'El usuario no está activo';
			return false;
		}

		$_SESSION['admin'] = $user;


		$users->auto_log = false;

		$users->modulo_id = $admin['admin_id'];
		$users->_fields('admin_last_login', date('Y-m-d H:i:s'));
		$users->_fields('admin_password', password_hash($password, PASSWORD_BCRYPT, ['cost' => 04]));
		$users->add();

		$users->log('security', 'login as', $admin['admin_id'], false);

		return true;
	}
	/**
	 * Login
	 *
	 * @param string $email
	 * @param string $password
	 * @return boolean
	 */
	public function Login($email, $password){

		$admins = new Admins();
		//$admins->debug=true;

		$email    = filter_input(INPUT_POST,'username',FILTER_SANITIZE_STRING);
		$password = filter_input(INPUT_POST,'password',FILTER_SANITIZE_STRING);

		$admins_list = $admins->get_list(1, 1, ' AND '.db::ftquote('admin_email').' = ' . db::quote($email).' AND `admin_activo` ');

		if(!$admins_list){
			$this->error = 'Error Interno';
			return false;
		}

		if(db::num_rows($admins_list) != 1){
			$this->error = 'Usuario o contraseña inválidos';
			return false;
		}

		$admin = db::fetch_assoc($admins_list);

		if (!password_verify($password, $admin['admin_password'])) {
			$this->error = 'Contraseña o usuario inválidos';
			return false;
		}

		if($admin['admin_activo'] == 0 || $admin['reg_deleted'] == 1){
			$this->error = 'El usuario no está activo';
			return false;
		}

		$_SESSION['admin'] = $admin;

		$admins->auto_log = false;

		$admins->modulo_id = $admin['admin_id'];
		$admins->_fields('admin_last_login', date('Y-m-d H:i:s'));
		$admins->_fields('admin_password', password_hash($password, PASSWORD_BCRYPT, ['cost' => 04]));
		$admins->add();

		$admins->log('security', 'login', $admin['admin_id'], false);

		return true;

	}

	public static function admin_super(){
		return (int) $_SESSION['admin']['admin_super'];
	}

	public static function admin_id(){
		return (int) $_SESSION['admin']['admin_id'];
	}
	/**
	 * Logout
	 *
	 */
	public static function Logout(){

		$_SESSION['admin'] = '';
		unset($_SESSION['admin']);
		session_destroy();
	}
	/**
	 * Is Logged
	 *
	 * @return boolean
	 */
	public static function is_logged(){

		if(isset($_SESSION['admin']) && $_SESSION['admin'] != ''){
			return true;
		}

		return false;
	}

}

?>